<?php
namespace Etracker\Etracker\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class DefaultController extends ActionController
{
    /**
     * @var array
     */
    protected $data;

    /**
     * @var \Etracker\Etracker\Domain\Repository\PageRepository
     * @inject
     */
    protected $pageRepository;

    /**
     * @var \Etracker\Etracker\Domain\Repository\PageOverlayRepository
     * @inject
     */
    protected $pageOverlayRepository;

    /**
     * @return void
     */
    public function initializeAction()
    {
        $this->data = $this->configurationManager->getContentObject()->data;
    }

    /**
     * @return void
     */
    public function indexAction()
    {
        $version = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getExtensionVersion($this->request->getControllerExtensionKey());
        $this->view->assign('version', $version);

        $this->view->assign('data', $this->data);

        if ($this->data['_PAGES_OVERLAY']) {
            $page = $this->pageOverlayRepository->findByUid($this->data['_PAGES_OVERLAY_UID']);
        } else {
            $page = $this->pageRepository->findByUid($this->data['uid']);
        }

        $et_areas = [];
        foreach ($page->getAreas() as $area) {
            $et_areas[] = $area->toString();
        }
        $this->view->assign('et_areas', implode(',', $et_areas));
    }

    /**
     * @return void
     */
    public function ecommerceAction()
    {
        $this->view->assign('data', $this->data);
    }
}

