<?php
namespace Etracker\Etracker\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Area extends AbstractEntity
{
    /**
     * @var \Etracker\Etracker\Domain\Repository\AreaRepository
     * @inject
     */
    protected $areaRepository;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var \Etracker\Etracker\Domain\Model\Area
     */
    protected $parentArea;

    /**
     * @var string
     */
    protected $description;

    /**
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param \Etracker\Etracker\Domain\Model\Area $parentArea
     * @return void
     */
    public function setParentArea($parentArea)
    {
        $this->parentArea = $parentArea;
    }

    /**
     * @return \Etracker\Etracker\Domain\Model\Area
     */
    public function getParentArea()
    {
        return $this->parentArea;
    }

    /**
     * @param string $description
     * @return void
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @return string
     */
    public function toString($areas = [])
    {
        if ($this->getParentArea()) {
            $areas[] = $this->getParentArea()->toString($areas);
        }
        $areas[] = $this->getTitle();

        return implode('/', $areas);
    }
}

